package com.example.andy.myapplication;

import android.graphics.Color;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;

import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.data.ScatterDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;

import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {
    ScatterChart scatterChart;
    ScatterData scatterData;
    ScatterDataSet scatterDataSet;
    ArrayList scatterEntries;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        scatterChart = findViewById(R.id.scatterChart);
        getEntries();
        scatterDataSet = new ScatterDataSet(scatterEntries, "");
        scatterData = new ScatterData(scatterDataSet);
        scatterChart.setData(scatterData);
        scatterDataSet.setColors(ColorTemplate.JOYFUL_COLORS);
        scatterDataSet.setValueTextColor(Color.BLACK);
        scatterDataSet.setValueTextSize(18f);

    }

    private void getEntries() {
        scatterEntries = new ArrayList<>();
        scatterEntries.add(new BarEntry(2f, 0));
        scatterEntries.add(new BarEntry(4f, 1));
        scatterEntries.add(new BarEntry(6f, 1));
        scatterEntries.add(new BarEntry(8f, 3));
        scatterEntries.add(new BarEntry(7f, 4));
        scatterEntries.add(new BarEntry(3f, 3));

    }

}
